﻿/*
	Include in output:

	This file is part of Natural Docs, which is Copyright © 2003-2023 Code Clear LLC.
	Natural Docs is licensed under version 3 of the GNU Affero General Public
	License (AGPL).  Refer to License.txt or www.naturaldocs.org for the
	complete details.

	This file may be distributed with documentation files generated by Natural Docs.
	Such documentation is not covered by Natural Docs' copyright and licensing,
	and may have its own copyright and distribution terms as decided by its author.
*/

"use strict";


/* Class: NDHomePage
	_____________________________________________________________________________

*/
var NDHomePage = new function ()
	{

	// Group: Functions
	// ________________________________________________________________________


	/* Function: Start
	*/
	this.Start = function ()
		{

		// Create event handlers

		this.messageEventHandler = NDHomePage.OnMessage.bind(NDHomePage);
		this.effectiveThemeChangeEventHandler = NDHomePage.OnEffectiveThemeChange.bind(NDHomePage);


		// Make sure NDThemes reflects any theme that was set via query parameter

		var themeID = NDCore.GetQueryParam('Theme');
		NDThemes.SetCurrentTheme(themeID, false);


		// Set up event listeners

		document.addEventListener("NDEffectiveThemeChange", this.effectiveThemeChangeEventHandler);
		window.addEventListener("message", this.messageEventHandler);
		};



	// Group: Event Handlers
	// ________________________________________________________________________


	/* Function: OnMessage

		Event handler for messages sent to this page by the frame page via postMessage().

		Supported Commands:

			NoTheme - Remove any theme classes.
			Theme=[id] - Apply the passed theme ID.
	*/
	this.OnMessage = function (event)
		{
		var message = event.data;

		if (message == "NoTheme")
			{  NDThemes.SetCurrentTheme(undefined, false);  }
		else if (message.startsWith("Theme="))
			{
			var theme = message.slice(6);
			NDThemes.SetCurrentTheme(theme, false);
			}
		};


	/* Function: OnEffectiveThemeChange
		Called whenever the effective theme changes.
	*/
	this.OnEffectiveThemeChange = function (event)
		{
		if (event.detail.oldEffectiveThemeID != undefined)
			{  document.documentElement.classList.remove(event.detail.oldEffectiveThemeID + "Theme");  }

		if (event.detail.newEffectiveThemeID != undefined)
			{  document.documentElement.classList.add(event.detail.newEffectiveThemeID + "Theme");  }
		};


	// Group: Event Handler Variables
	// ________________________________________________________________________

	/* var: messageEventHandler
		A bound function to call <OnMessage()> with NDHomePage always as "this".
	*/

	/* var: effectiveThemeChangeEventHandler
		A bound function to call <OnEffectiveThemeChange()> with NDHomePage always as "this".
	*/

	};
